package kochModel.factory;

import kochModel.*;
import lrs.*;
import java.awt.geom.Point2D.Double;

public class KochFractalFactory extends FractalFactory {
  
  public KochFractalFactory() {
    Double p0 = new Double(0.0,0.0);
    Double p1 = new Double(1.0/3.0,0.0);
    Double p2 = new Double(0.5,-1.0/3.0*Math.sqrt(3.0)/2.0);
    Double p3 = new Double(2.0/3.0,0.0);
    Double p4 = new Double(1.0, 0.0);
    
    LRStruct<Koch> children = new LRStruct<Koch>();
    children.insertFront(new Koch(p3, p4));
    children.insertFront(new Koch(p2, p3));
    children.insertFront(new Koch(p1, p2));
    children.insertFront(new Koch(p0, p1));
    
    setProto(new Koch(p0, p4, children));
  }
}
